/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.network.client.data.NetworkDataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

@FunctionalInterface
public interface ArmorStandScreenFactory<T extends Screen & ArmorStandScreen> {
    public static final Map<ArmorStandScreenType, ArmorStandScreenFactory<?>> FACTORIES = Maps.newHashMap();

    public T create(ArmorStandHolder var1, Inventory var2, Component var3, DataSyncHandler var4);

    public static <T extends Screen & ArmorStandScreen> T createScreenType(ArmorStandScreenType screenType, ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        AbstractArmorStandScreen.lastScreenType = screenType;
        ArmorStandScreenFactory<?> factory = FACTORIES.get(screenType);
        if (factory == null) {
            throw new IllegalStateException("No screen factory registered for armor stand screen type %s".formatted(screenType));
        }
        Object screen = factory.create(holder, inventory, component, dataSyncHandler);
        if (((ArmorStandScreen)screen).getScreenType() != screenType) {
            throw new IllegalStateException("Armor stand screen type mismatch: %s and %s".formatted(((ArmorStandScreen)screen).getScreenType(), screenType));
        }
        return (T)screen;
    }

    public static <T extends Screen & ArmorStandScreen> T createLastScreenType(ArmorStandMenu menu, Inventory inventory, Component component) {
        return ArmorStandScreenFactory.createLastScreenType(menu, inventory, component, new NetworkDataSyncHandler(menu));
    }

    public static <T extends Screen & ArmorStandScreen> T createLastScreenType(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        HashSet screenTypes = Sets.newHashSet((Object[])dataSyncHandler.getScreenTypes());
        Optional<ArmorStandScreenType> lastScreenType = Optional.ofNullable(AbstractArmorStandScreen.lastScreenType).filter(screenTypes::contains).filter(dataSyncHandler::supportsScreenType);
        ArmorStandScreenType screenType = lastScreenType.orElse(dataSyncHandler.getArmorStandHolder().getDataProvider().getDefaultScreenType());
        return ArmorStandScreenFactory.createScreenType(screenType, holder, inventory, component, dataSyncHandler);
    }

    public static void register(ArmorStandScreenType screenType, ArmorStandScreenFactory<?> factory) {
        if (FACTORIES.put(screenType, factory) != null) {
            throw new IllegalStateException("Attempted to register duplicate screen factory for armor stand screen type %s".formatted(screenType));
        }
    }
}

